*** we want to see if there is a bank bubble
use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data September 2016\merge_lt_v2.dta", clear 
** need to add in bank index
import delimited "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\finance_index_close.csv", clear 
gen date_num = date(date, "MDY")
format date_num %td
drop date
rename date_num date 
save "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\finance_index.dta", replace 

use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data September 2016\merge_lt_v2.dta", clear 
merge m:1 date using "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\finance_index.dta"
br if _merge != 3 & year > 1993 & year < 2016
keep if _merge == 3
drop _merge 
save "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\long_term_with_index.dta", replace 

use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\long_term_with_index.dta", clear 


*** then need to calculate everything divided by S&P 500 index 
gen fin_index_div_market = adjclose/spindx
*gen price_div_market = prc/spindx

egen id = group(name)
tsset id date 

tssmooth ma price_div_market_ma = price_div_market, window(90)
tssmooth ma fin_index_div_market_ma = fin_index_div_market, window(90)

cd "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Tables"

label var price_div_market_ma "Price/Market"
label var fin_index_div_market_ma "Fin Index/Market"

graph twoway (line fin_index_div_market_ma date, yaxis(1) cmissing(no) ytitle("Fin Index/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "baml" & year>1993), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_price_div_market.png, replace 

graph twoway (line fin_index_div_market_ma date, yaxis(1) cmissing(no) ytitle("Fin Index/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "citi" & year>1993), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_price_div_market.png, replace 

graph twoway (line fin_index_div_market_ma date, yaxis(1) cmissing(no) ytitle("Fin Index/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "ms" & year>1994), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_price_div_market.png, replace 

graph twoway (line fin_index_div_market_ma date, yaxis(1) cmissing(no) ytitle("Fin Index/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "gs" & year>1999), xtitle("") title("Goldman Sachs") xlabel(,labsize(small))  

graph export gs_price_div_market.png, replace 

graph twoway (line fin_index_div_market_ma date, yaxis(1) cmissing(no) ytitle("Fin Index/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2)))  if (name == "wf" & year>1993), xtitle("") title("Wells Fargo") xlabel(,labsize(small))  

graph export wf_price_div_market.png, replace 

graph twoway (line fin_index_div_market_ma date, yaxis(1) cmissing(no) ytitle("Fin Index/Market")) || (line price_div_market_ma date, yaxis(2) cmissing(no) ytitle("Price/Market", axis(2))) if (name == "jpm" & year>1993), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_price_div_market.png, replace

save "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\long_term_with_index.dta", replace 


*** then need to graph 
*** one graph for index, one for each bank 
